/*
 * Author: Mattanaw 
 * Updated for Com: 3/31/2024,3/30/2024
 * Original Completion Date: 7/17/2016
 * Purpose: very simple implementation of CryptoJS
 * Goal: provide very simply encryption and decryption to
 * avoid any external application install, for simple protection.
 * Goal: provide communication and encrypted file download and conversion.
 */


(function() {


var encrypt = document.getElementById('encrypt'),
    decrypt = document.getElementById('decrypt'),
    clearall = document.getElementById('clearall'),
    passPhrase = document.getElementById('passPhrase'),
    plainText = document.getElementById('plaintext'),
    cipherText = document.getElementById('ciphertext');

encrypt.addEventListener('click', function() {

var plainTextValue = plainText.value,
    passPhraseValue = passPhrase.value;


if (plainTextValue && passPhraseValue) {

    var encrypted = CryptoJS.AES.encrypt(plainTextValue, passPhraseValue);
    cipherText.value = encrypted;


} else {

    alert("Please enter your plaintext or passphrase");

}

});

decrypt.addEventListener('click', function() {

var cipherTextValue = cipherText.value,
    passPhraseValue = passPhrase.value;


if (cipherTextValue && passPhraseValue) {

    var decrypted = CryptoJS.AES.decrypt(cipherTextValue, passPhraseValue);
    plainText.value = decrypted.toString(CryptoJS.enc.Utf8);


} else {

    alert("Please enter your ciphertext or your passphrase");

}

});


clearall.addEventListener('click', function(e) {

	e.preventDefault();
	e.stopPropagation();

	plainText.value = ""; cipherText.value = ""; passPhrase.value = "";

});


$(document).ready(function() {

$("#send").on("click", function(){

var cipherField = document.getElementById('ciphertext'),
    encryptedMessage = cipherField.value,
    nameField = document.getElementById('nameField'),
    nameText = nameField.value,
    identityField = document.getElementById('identity'),
    identityText = identity.value,
    subjectField = document.getElementById('subject'),
    subjectText = subject.value,
    relationField = document.getElementById('relation'),
    relationText = relation.value,
    charString = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789",
    charLength = charString.length,
    randomNineCharString = "",
    randomNumber = Math.random().toString(),
    digitSelect1 = randomNumber.charAt(3),
    digitSelect2 = randomNumber.charAt(4);

// Set a letter for each of the 1-9 character positions for 9 chars total, by getting different random numbers for each and choosing a character from the charString
for (i=0; i <= 8; i++) {

    randomNumber = Math.random().toString(),
    digitSelect1 = randomNumber.charAt(3),
    digitSelect2 = randomNumber.charAt(4);

    twoDigitString = digitSelect1+digitSelect2;
    twoDigitNumber = Number(twoDigitString);

while (twoDigitNumber > 62) {

    randomNumber = Math.random().toString();
    digitSelect1 = randomNumber.charAt(3);
    digitSelect2 = randomNumber.charAt(4);

    twoDigitString = digitSelect1+digitSelect2;
    twoDigitNumber = Number(twoDigitString);

};

    randomNineCharString = randomNineCharString + charString.charAt(twoDigitNumber);

}

$.ajaxSetup({ cache: false });

var messageUrl = 'com.html?name=' + nameText + '&identity=' + identityText +  '&subject=' + subjectText + '&relation=' + relationText + '&link=' + randomNineCharString + '&message=' + encryptedMessage;

$.get(messageUrl, (function(){

$("#status").html("Sent!");
$("#link").html("Our Link: http://www.mattanaw.com/com-" + randomNineCharString + ".html")

}));});

});


//end of main function
})();

